/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

import java.io.IOException;

import org.apache.lucene.store.IndexOutput;

/**
 * @deprecated
 */
class JCRIndexOutput extends IndexOutput {

    private final JCRDirectory directory;

    private final String name;

    private byte[] data;

    private int length;

    private int position = 0;

    private boolean dirty = false;

    public JCRIndexOutput(JCRDirectory directory, String name)
            throws IOException {
        this.directory = directory;
        this.name = name;
        this.data = directory.readFile(name);
        if (data != null) {
            length = data.length;
        } else {
            data = new byte[1024];
            length = 0;
        }
    }

    private synchronized void grow(int n) {
        if (position + n > data.length) {
            byte[] buffer = new byte[Math.max(position + n, data.length * 2)];
            System.arraycopy(data, 0, buffer, 0, length);
            data = buffer;
        }
        if (position + n > length) {
            length = position + n;
        }
    }

    @Override
    public synchronized void writeByte(byte b) throws IOException {
        grow(1);
        data[position++] = b;
        dirty = true;
    }

    @Override
    public synchronized void writeBytes(byte[] b, int offset, int length) throws IOException {
        grow(length);
        System.arraycopy(b, offset, data, position, length);
        position += length;
        dirty = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (dirty) {
            byte[] buffer = data;
            if (length != data.length) {
                buffer = new byte[length];
                System.arraycopy(data, 0, buffer, 0, length);
            }
            directory.writeFile(name, buffer);
            dirty = false;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        flush();
    }

    @Override
    public synchronized long getFilePointer() {
        return position;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (0 <= pos && pos < length) {
            position = (int) pos;
        } else {
            throw new IOException();
        }
    }

    @Override
    public synchronized long length() throws IOException {
        return length;
    }

}
