/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

import java.io.IOException;

import javax.jcr.Session;
import javax.jcr.lock.LockManager;

import org.apache.lucene.store.Lock;

/**
 * @deprecated
 */
public class JCRLock extends Lock {

    private final Session session;

    private final String path;

    JCRLock(final Session session, final String path) {
        this.session = session;
        this.path = path;
    }

    @Override
    public boolean obtain() throws IOException {
        try {
            LockManager lm = session.getWorkspace().getLockManager();
            lm.lock(path, true, true, 0, "JCRLockFactory");
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    @Override
    public void release() throws IOException {
        try {
            LockManager lm = session.getWorkspace().getLockManager();
            lm.unlock(path);
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean isLocked() throws IOException {
        try {
            LockManager lm = session.getWorkspace().getLockManager();
            return lm.holdsLock(path);
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}
