/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

/**
 * @deprecated
 */
public class LongField {

    private static final int STRING_LONG_LEN
            = Long.toString(Long.MAX_VALUE, Character.MAX_RADIX).length() + 1;

    private LongField() {

    }

    public static String longToString(long value) {
        StringBuffer sb = new StringBuffer(STRING_LONG_LEN);
        if (value < 0) {
            // shift value
            value += Long.MAX_VALUE;
            value++;
            // after shift
            // Long.MIN_VALUE -> 0
            // 1 -> Long.MAX_VALUE

            // convert into string
            String s = Long.toString(value, Character.MAX_RADIX);
            // pad with leading zeros
            while ((sb.length() + s.length()) < STRING_LONG_LEN) {
                sb.append('0');
            }
            sb.append(s);
        } else {
            // convert into string
            String s = Long.toString(value, Character.MAX_RADIX);
            // mark as positive
            sb.append('1');
            // fill in zeros if needed
            while ((sb.length() + s.length()) < STRING_LONG_LEN) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static long stringToLong(String value) {
        if (value.charAt(0) == '1') {
            // positive
            return Long.parseLong(value.substring(1), Character.MAX_RADIX);
        }
        if (value.charAt(0) == '0') {
            // negative
            long longValue = Long.parseLong(value, Character.MAX_RADIX);
            // reverse shift
            longValue -= Long.MAX_VALUE;
            return --longValue;
        } else {
            throw new IllegalArgumentException(value);
        }
    }
}
