/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

import java.util.ArrayList;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;

/**
 * @deprecated
 */
class LuceneSearchCollectionConfig {

    private static final String PROPERTY_INCLUDES = "includes";
    private static final String PROPERTY_EXCLUDES = "excludes";

    private final List<String> includes;
    private final List<String> excludes;

    LuceneSearchCollectionConfig(Node directory) throws RepositoryException {
        this.includes = getOrElse(directory, PROPERTY_INCLUDES, null);
        this.excludes = getOrElse(directory, PROPERTY_EXCLUDES, null);
    }

    public boolean shouldInclude(String path) {
        return matchesIncludes(path) && !matchesExcludes(path);
    }

    private boolean matchesIncludes(String path) {
        return matches(this.includes, path);
    }

    private boolean matchesExcludes(String path) {
        return matches(this.excludes, path);
    }

    private boolean matches(List<String> rules, String path) {
        if (rules == null || rules.isEmpty() || path == null) {
            return false;
        }
        for (String r : rules) {
            if (path.startsWith(r)) {
                return true;
            }
        }
        return false;
    }

    private static List<String> getOrElse(Node node, String property,
            String defVal) throws RepositoryException {
        String v = null;
        try {
            v = node.getProperty(property).getString();
        } catch (PathNotFoundException e) {
            // ignore missing config
        }
        if (v == null) {
            return null;
        }
        List<String> retval = new ArrayList<String>();

        String[] vs = v.split(",");
        for (String val : vs) {
            if (val.trim().length() > 0) {
                retval.add(val.trim());
            }
        }
        return retval;
    }

}