/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.lucene;

import java.io.IOException;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

/**
 * @deprecated
 */
class SubtreeTermEnum extends FilteredTermEnum {

    private final String path;

    private final boolean includeRoot;

    private volatile boolean end = false;

    public SubtreeTermEnum(
            IndexReader reader, String path, boolean includeRoot)
            throws IOException {
        this.path = path;
        this.includeRoot = includeRoot;
        setEnum(reader.terms(new Term(":path", path)));
    }

    @Override
    protected boolean termCompare(Term term) {
        String field = term.field();
        String text = term.text();
        if (field.equals(":path") && text.startsWith(path)) {
            if (text.equals(path)) {
                return includeRoot;
            } else {
                return path.equals("/") || text.startsWith(path + "/");
            }
        } else {
            end = true;
            return false;
        }
    }

    @Override
    protected boolean endEnum() {
        return end;
    }

    @Override
    public float difference() {
        return 1.0f;
    }

}
