/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.HashMap;
import java.util.Map;

import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.version.VersionException;

/**
 * @deprecated
 */
public abstract class AbstractQuery implements Query {

    private final String statement;

    private final String language;

    private final Map<String, Value> bindVariables =
        new HashMap<String, Value>();

    private volatile long offset = 0;

    private volatile long limit = Long.MAX_VALUE;

    protected AbstractQuery(
            String statement, String language, String... variables) {
        this.statement = statement;
        this.language = language;
        for (String variable : variables) {
            bindVariables.put(variable, null);
        }
    }

    public String getStatement() {
        return statement;
    }

    public String getLanguage() {
        return language;
    }

    public long getOffset() {
        return offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return bindVariables.keySet().toArray(new String[bindVariables.size()]);
    }

    public Value getBindValue(String varName) {
        return bindVariables.get(varName);
    }

    public void bindValue(String varName, Value value)
            throws IllegalArgumentException, RepositoryException {
        if (bindVariables.containsKey(varName)) {
            bindVariables.put(varName, value);
        } else {
            throw new IllegalArgumentException(
                    "No such bind variable: " + varName);
        }
    }

    public Node storeAsNode(String absPath)
            throws ItemExistsException, PathNotFoundException,
            VersionException, ConstraintViolationException, LockException,
            UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String getStoredQueryPath()
            throws ItemNotFoundException, RepositoryException {
        throw new ItemNotFoundException("Not a stored query");
    }

}
