/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.HashSet;
import java.util.Set;

import javax.jcr.query.Query;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;

/**
 * @deprecated
 */
public abstract class AbstractQueryObjectModel
        extends AbstractQuery implements QueryObjectModel {

    private final Source source;

    private final Constraint constraint;

    private final Ordering[] orderings;

    private final Column[] columns;

    protected AbstractQueryObjectModel(
            Source source, Constraint constraint,
            Ordering[] orderings, Column[] columns) {
        super(null, Query.JCR_JQOM, getBindVariableNames(constraint));
        this.source = source;
        this.constraint = constraint;
        this.orderings = orderings;
        this.columns = columns;
    }

    public String getStatement() {
        return null; // TODO
    }

    public Source getSource() {
        return source;
    }

    public Constraint getConstraint() {
        return constraint;
    }

    public Ordering[] getOrderings() {
        return orderings;
    }

    public Column[] getColumns() {
        return columns;
    }

    private static String[] getBindVariableNames(Constraint constraint) {
        Set<String> names = new HashSet<String>();
        collectBindVariableNames(names, constraint);
        return names.toArray(new String[names.size()]);
    }

    private static void collectBindVariableNames(
            Set<String> names, Constraint constraint) {
        if (constraint instanceof And) {
            And and = (And) constraint;
            collectBindVariableNames(names, and.getConstraint1());
            collectBindVariableNames(names, and.getConstraint2());
        } else if (constraint instanceof Or) {
            Or or = (Or) constraint;
            collectBindVariableNames(names, or.getConstraint1());
            collectBindVariableNames(names, or.getConstraint2());
        } else if (constraint instanceof Not) {
            Not not = (Not) constraint;
            collectBindVariableNames(names, not.getConstraint());
        } else if (constraint instanceof Comparison) {
        	Comparison comp = (Comparison) constraint;
        	Object op1 = comp.getOperand1();
        	Object op2 = comp.getOperand2();
        	
        	if (op1 instanceof BindVariableValue) {
                BindVariableValue bvv = (BindVariableValue) op1;
                names.add(bvv.getBindVariableName());
            }
        	
        	if (op2 instanceof BindVariableValue) {
                BindVariableValue bvv = (BindVariableValue) op2;
                names.add(bvv.getBindVariableName());
            }
        	
        } else if (constraint instanceof BindVariableValue) {
            BindVariableValue bvv = (BindVariableValue) constraint;
            names.add(bvv.getBindVariableName());
        }
    }

}