/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelConstants;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;

/**
 * @deprecated
 */
public abstract class AbstractQueryObjectModelFactory
        implements QueryObjectModelFactory {

    public Selector selector(
            final String nodeTypeName, final String selectorName)
            throws InvalidQueryException, RepositoryException {
        return new Selector() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getNodeTypeName() {
                return nodeTypeName;
            }

            public String toString() {
                return "selector(name=" + selectorName + ";nodeType="
                        + nodeTypeName + ")";
            }
        };
    }

    public Join join(
            final Source left, final Source right,
            final String joinType, final JoinCondition joinCondition)
            throws InvalidQueryException, RepositoryException {
        return new Join() {
            public Source getLeft() {
                return left;
            }
            public Source getRight() {
                return right;
            }
            public String getJoinType() {
                return joinType;
            }
            public JoinCondition getJoinCondition() {
                return joinCondition;
            }
        };
    }

    public EquiJoinCondition equiJoinCondition(
            final String selector1Name, final String property1Name,
            final String selector2Name, final String property2Name)
            throws InvalidQueryException, RepositoryException {
        return new EquiJoinCondition() {
            public String getSelector1Name() {
                return selector1Name;
            }
            public String getProperty1Name() {
                return property1Name;
            }
            public String getSelector2Name() {
                return selector2Name;
            }
            public String getProperty2Name() {
                return property2Name;
            }
        };
    }

    public SameNodeJoinCondition sameNodeJoinCondition(
            final String selector1Name,
            final String selector2Name, final String selector2Path)
            throws InvalidQueryException, RepositoryException {
        return new SameNodeJoinCondition() {
            public String getSelector1Name() {
                return selector1Name;
            }
            public String getSelector2Name() {
                return selector2Name;
            }
            public String getSelector2Path() {
                return selector2Path;
            }
        };
    }

    public ChildNodeJoinCondition childNodeJoinCondition(
            final String childSelectorName, final String parentSelectorName)
            throws InvalidQueryException, RepositoryException {
        return new ChildNodeJoinCondition() {
            public String getChildSelectorName() {
                return childSelectorName;
            }
            public String getParentSelectorName() {
                return parentSelectorName;
            }
        };
    }

    public DescendantNodeJoinCondition descendantNodeJoinCondition(
            final String descendantSelectorName,
            final String ancestorSelectorName)
            throws InvalidQueryException, RepositoryException {
        return new DescendantNodeJoinCondition() {
            public String getDescendantSelectorName() {
                return descendantSelectorName;
            }
            public String getAncestorSelectorName() {
                return ancestorSelectorName;
            }
        };
    }

    public And and(final Constraint constraint1, final Constraint constraint2)
            throws InvalidQueryException, RepositoryException {
        return new And() {
            public Constraint getConstraint1() {
                return constraint1;
            }
            public Constraint getConstraint2() {
                return constraint2;
            }
            public String toString() {
                return "and(c1=" + constraint1 + ";c2=" + constraint2 + ")";
            }
        };
    }

    public Or or(final Constraint constraint1, final Constraint constraint2)
            throws InvalidQueryException, RepositoryException {
        return new Or() {
            public Constraint getConstraint1() {
                return constraint1;
            }
            public Constraint getConstraint2() {
                return constraint2;
            }
            public String toString() {
                return "or(c1=" + constraint1 + ";c2=" + constraint2 + ")";
            }
        };
    }

    public Not not(final Constraint constraint)
            throws InvalidQueryException, RepositoryException {
        return new Not() {
            public Constraint getConstraint() {
                return constraint;
            }
            public String toString() {
                return "not(c=" + constraint + ")";
            }
        };
    }

    public Comparison comparison(
            final DynamicOperand operand1, final String operator,
            final StaticOperand operand2)
            throws InvalidQueryException, RepositoryException {
        return new Comparison() {
            public DynamicOperand getOperand1() {
                return operand1;
            }
            public String getOperator() {
                return operator;
            }
            public StaticOperand getOperand2() {
                return operand2;
            }
            public String toString() {
                return "comparison(operand1=" + operand1 + ";operator="
                        + operator + ";operand2=" + operand2 + ")";
            }
        };
    }

    public PropertyExistence propertyExistence(
            final String selectorName, final String propertyName)
            throws InvalidQueryException, RepositoryException {
        return new PropertyExistence() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getPropertyName() {
                return propertyName;
            }
            public String toString() {
                return "propertyExistence(selectorName=" + selectorName
                        + ";propertyName=" + propertyName + ")";
            }
        };
    }

    public FullTextSearch fullTextSearch(
            final String selectorName, final String propertyName,
            final StaticOperand fullTextSearchExpression)
            throws InvalidQueryException, RepositoryException {
        return new FullTextSearch() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getPropertyName() {
                return propertyName;
            }
            public StaticOperand getFullTextSearchExpression() {
                return fullTextSearchExpression;
            }
            public String toString() {
                return "fullTextSearch(selectorName=" + selectorName
                        + ";propertyName=" + propertyName
                        + ";fullTextSearchExpression="
                        + fullTextSearchExpression + ")";
            }
        };
    }

    public SameNode sameNode(final String selectorName, final String path)
            throws InvalidQueryException, RepositoryException {
        return new SameNode() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getPath() {
                return path;
            }
        };
    }

    public ChildNode childNode(final String selectorName, final String path)
            throws InvalidQueryException, RepositoryException {
        return new ChildNode() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getParentPath() {
                return path;
            }
        };
    }

    public DescendantNode descendantNode(
            final String selectorName, final String path)
            throws InvalidQueryException, RepositoryException {
        return new DescendantNode() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getAncestorPath() {
                return path;
            }
        };
    }

    public PropertyValue propertyValue(
            final String selectorName, final String propertyName)
            throws InvalidQueryException, RepositoryException {
        return new PropertyValue() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getPropertyName() {
                return propertyName;
            }
            public String toString() {
                return "propertyValue(selectorName=" + selectorName
                        + ";propertyName=" + propertyName + ")";
            }
        };
    }

    public Length length(final PropertyValue propertyValue)
            throws InvalidQueryException, RepositoryException {
        return new Length() {
            public PropertyValue getPropertyValue() {
                return propertyValue;
            }
        };
    }

    public NodeName nodeName(final String selectorName)
            throws InvalidQueryException, RepositoryException {
        return new NodeName() {
            public String getSelectorName() {
                return selectorName;
            }
        };
    }

    public NodeLocalName nodeLocalName(final String selectorName)
            throws InvalidQueryException, RepositoryException {
        return new NodeLocalName() {
            public String getSelectorName() {
                return selectorName;
            }
        };
    }

    public FullTextSearchScore fullTextSearchScore(final String selectorName)
            throws InvalidQueryException, RepositoryException {
        return new FullTextSearchScore() {
            public String getSelectorName() {
                return selectorName;
            }
        };
    }

    public LowerCase lowerCase(final DynamicOperand operand)
            throws InvalidQueryException, RepositoryException {
        return new LowerCase() {
            public DynamicOperand getOperand() {
                return operand;
            }
        };
    }

    public UpperCase upperCase(final DynamicOperand operand)
            throws InvalidQueryException, RepositoryException {
        return new UpperCase() {
            public DynamicOperand getOperand() {
                return operand;
            }
        };
    }

    public BindVariableValue bindVariable(final String bindVariableName)
            throws InvalidQueryException, RepositoryException {
        return new BindVariableValue() {
            public String getBindVariableName() {
                return bindVariableName;
            }
        };
    }

    public Literal literal(final Value literalValue)
            throws InvalidQueryException, RepositoryException {
        return new Literal() {
            public Value getLiteralValue() {
                return literalValue;
            }
        };
    }

    public Ordering ascending(final DynamicOperand operand)
            throws InvalidQueryException, RepositoryException {
        return new Ordering() {
            public String getOrder() {
                return QueryObjectModelConstants.JCR_ORDER_ASCENDING;
            }
            public DynamicOperand getOperand() {
                return operand;
            }
        };
    }

    public Ordering descending(final DynamicOperand operand)
            throws InvalidQueryException, RepositoryException {
        return new Ordering() {
            public String getOrder() {
                return QueryObjectModelConstants.JCR_ORDER_DESCENDING;
            }
            public DynamicOperand getOperand() {
                return operand;
            }
        };
    }

    public Column column(
            final String selectorName, final String propertyName,
            final String columnName)
            throws InvalidQueryException, RepositoryException {
        return new Column() {
            public String getSelectorName() {
                return selectorName;
            }
            public String getPropertyName() {
                return propertyName;
            }
            public String getColumnName() {
                return columnName;
            }
            public String toString() {
                return "column(selectorName=" + selectorName + ";propertyName="
                        + propertyName + ";columnName=" + columnName + ")";
            }
        };
    }

}
