/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.Map;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.PropertyValue;

/**
 * @deprecated
 */
abstract class AbstractRow implements Row {

    private final Map<String, PropertyValue> columns;

    private final OperandEvaluator evaluator;

    protected AbstractRow(
            Map<String, PropertyValue> columns, OperandEvaluator evaluator) {
        this.columns = columns;
        this.evaluator = evaluator;
    }

    public Value[] getValues() throws RepositoryException {
        Value[] values = new Value[columns.size()];
        for (Operand operand : columns.values()) {
            values = evaluator.getValues(operand, this);
        }
        return values;
    }

    public Value getValue(String columnName)
            throws ItemNotFoundException, RepositoryException {
        Operand operand = columns.get(columnName);
        if (operand != null) {
            return evaluator.getValue(operand, this);
        } else {
            throw new ItemNotFoundException(
                    "Column " + columnName + " is not included in this row");
        }
    }

    public String getPath() throws RepositoryException {
        Node node = getNode();
        if (node != null) {
            return node.getPath();
        } else {
            return null;
        }
    }

    public String getPath(String selectorName) throws RepositoryException {
        Node node = getNode(selectorName);
        if (node != null) {
            return node.getPath();
        } else {
            return null;
        }
    }

}
