/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;

/**
 * @deprecated
 */
class ChildNodeJoinMerger extends JoinMerger {

    private final String childSelector;

    private final String parentSelector;

    public ChildNodeJoinMerger(
            Join join, Map<String, PropertyValue> columns,
            OperandEvaluator evaluator, QueryObjectModelFactory factory,
            ChildNodeJoinCondition condition)
            throws RepositoryException {
        super(join, columns, evaluator, factory);
        this.childSelector = condition.getChildSelectorName();
        this.parentSelector = condition.getParentSelectorName();
    }

    @Override
    public Set<String> getLeftValues(Row row) throws RepositoryException {
        return getValues(leftSelectors, row);
    }

    @Override
    public Set<String> getRightValues(Row row) throws RepositoryException {
        return getValues(rightSelectors, row);
    }

    @Override
    public List<Constraint> getRightJoinConstraints(List<Row> leftRows)
            throws RepositoryException {
        Set<String> paths = new HashSet<String>();
        for (Row row : leftRows) {
            paths.addAll(getLeftValues(row));
        }

        List<Constraint> constraints = new ArrayList<Constraint>();
        for (String path: paths) {
            if (rightSelectors.contains(childSelector)) {
                constraints.add(factory.childNode(childSelector, path));
            } else {
                constraints.add(factory.sameNode(parentSelector, path));
            }
        }
        return constraints;
    }

    private Set<String> getValues(Set<String> selectors, Row row)
            throws RepositoryException {
        if (selectors.contains(childSelector)) {
            Node node = row.getNode(childSelector);
            if (node != null && node.getDepth() > 0) {
                return Collections.singleton(node.getParent().getPath());
            }
        } else if (selectors.contains(parentSelector)) {
            Node node = row.getNode(parentSelector);
            if (node != null) {
                return Collections.singleton(node.getPath());
            }
        } else {
            throw new RepositoryException("Invalid child node join");
        }
        return Collections.emptySet();
    }

}
