/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.Map;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.PropertyValue;

/**
 * @deprecated
 */
public class JoinRow extends AbstractRow {

    private final Row leftRow;

    private final Set<String> leftSelectors;

    private final Row rightRow;

    private final Set<String> rightSelectors;

    public JoinRow(
            Map<String, PropertyValue> columns, OperandEvaluator evaluator,
            Row leftRow, Set<String> leftSelectors,
            Row rightRow, Set<String> rightSelectors) {
        super(columns, evaluator);
        this.leftRow = leftRow;
        this.leftSelectors = leftSelectors;
        this.rightRow = rightRow;
        this.rightSelectors = rightSelectors;
    }

    public Node getNode() throws RepositoryException {
        throw new RepositoryException();
    }

    public Node getNode(String selectorName) throws RepositoryException {
        Row row = getRow(selectorName);
        if (row != null) {
            return row.getNode(selectorName);
        } else {
            return null;
        }
    }

    public double getScore() throws RepositoryException {
        throw new RepositoryException();
    }

    public double getScore(String selectorName) throws RepositoryException {
        Row row = getRow(selectorName);
        if (row != null) {
            return row.getScore(selectorName);
        } else {
            return 0.0;
        }
    }

    private Row getRow(String selector) throws RepositoryException {
        if (leftSelectors.contains(selector)) {
            return leftRow;
        } else if (rightSelectors.contains(selector)) {
            return rightRow;
        } else {
            throw new RepositoryException(
                    "Selector " + selector + " is not included in this row");
        }
    }

    //--------------------------------------------------------------< Object >

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (String selector : leftSelectors) {
            builder.append(selector);
            builder.append("=");
            try {
                builder.append(leftRow.getNode(selector));
            } catch (RepositoryException e) {
                builder.append(e.getMessage());
            }
            builder.append(" ");
        }
        for (String selector : rightSelectors) {
            builder.append(selector);
            builder.append("=");
            try {
                builder.append(rightRow.getNode(selector));
            } catch (RepositoryException e) {
                builder.append(e.getMessage());
            }
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

}
