/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_ORDER_DESCENDING;

import java.util.Comparator;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Ordering;

/**
 * Row comparator.
 * 
 * @deprecated
 */
public class RowComparator implements Comparator<Row> {

    private final ValueComparator comparator = new ValueComparator();

    private final Ordering[] orderings;

    private final OperandEvaluator evaluator;

    public RowComparator(
            Ordering[] orderings, OperandEvaluator evaluator) {
        this.orderings = orderings;
        this.evaluator = evaluator;
    }

    public int compare(Row a, Row b) {
        try {
            for (Ordering ordering : orderings) {
                Operand operand = ordering.getOperand();
                Value[] va = evaluator.getValues(operand, a);
                Value[] vb = evaluator.getValues(operand, b);
                int d = compare(va, vb);
                if (d != 0) {
                    if (JCR_ORDER_DESCENDING.equals(ordering.getOrder())) {
                        return -d;
                    } else {
                        return d;
                    }
                }
            }
            return 0;
        } catch (RepositoryException e) {
            throw new RuntimeException(
                    "Unable to compare rows " + a + " and " + b, e);
        }
    }

    private int compare(Value[] a, Value[] b) {
        for (int i = 0; i < a.length && i < b.length; i++) {
            int d = comparator.compare(a[i], b[i]);
            if (d != 0) {
                return d;
            }
        }
        return a.length - b.length;
    }

}