/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNodeJoinCondition;

/**
 * @deprecated
 */
class SameNodeJoinMerger extends JoinMerger {

    private final String selector1;

    private final String selector2;

    private final String path;

    public SameNodeJoinMerger(
            Join join, Map<String, PropertyValue> columns,
            OperandEvaluator evaluator, QueryObjectModelFactory factory,
            SameNodeJoinCondition condition) throws RepositoryException {
        super(join, columns, evaluator, factory);
        this.selector1 = condition.getSelector1Name();
        this.selector2 = condition.getSelector2Name();
        this.path = condition.getSelector2Path();
    }

    @Override
    public Set<String> getLeftValues(Row row) throws RepositoryException {
        return getValues(leftSelectors, row);
    }

    @Override
    public Set<String> getRightValues(Row row) throws RepositoryException {
        return getValues(rightSelectors, row);
    }

    @Override
    public List<Constraint> getRightJoinConstraints(List<Row> leftRows)
            throws RepositoryException {
        Set<String> paths = new HashSet<String>();
        for (Row row : leftRows) {
            paths.addAll(getLeftValues(row));
        }

        List<Constraint> constraints = new ArrayList<Constraint>();
        for (String path : paths) {
            if (rightSelectors.contains(selector1)) {
                constraints.add(factory.sameNode(selector1, path));
            } else {
                constraints.add(factory.sameNode(selector2, path));
            }
        }
        return constraints;
    }

    private Set<String> getValues(Set<String> selectors, Row row)
            throws RepositoryException {
        if (selectors.contains(selector1)) {
            Node node = row.getNode(selector1);
            if (node != null) {
                return Collections.singleton(node.getPath());
            }
        } else if (selectors.contains(selector2)) {
            Node node = row.getNode(selector2);
            if (node != null) {
                try {
                    String p = node.getPath();
                    if (path != null && !".".equals(path)) {
                        if (!"/".equals(p)) {
                            p += "/";
                        }
                        p += path;
                    }
                    return Collections.singleton(p);
                } catch (PathNotFoundException e) {
                    // fall through
                }
            }
        } else {
            throw new RepositoryException("Invalid same node join");
        }
        return Collections.emptySet();
    }

}
