/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.PropertyValue;

/**
 * A row implementation for a query with just a single selector.
 * 
 * @deprecated
 */
public class SelectorRow extends AbstractRow {

    private final String selector;

    private final Node node;

    private final double score;

    public SelectorRow(
            Map<String, PropertyValue> columns, OperandEvaluator evaluator,
            String selector, Node node, double score) {
        super(columns, evaluator);
        this.selector = selector;
        this.node = node;
        this.score = score;
    }

    public Node getNode() {
        return node;
    }

    public Node getNode(String selectorName) throws RepositoryException {
        checkSelectorName(selectorName);
        return node;
    }

    public double getScore() {
        return score;
    }

    public double getScore(String selectorName) throws RepositoryException {
        checkSelectorName(selectorName);
        return score;
    }

    private void checkSelectorName(String name) throws RepositoryException {
        if (!selector.equals(name)) {
            throw new RepositoryException(
                    "Selector " + name + " is not included in this row");
        }
    }

    //--------------------------------------------------------------< Object >

    public String toString() {
        return "{ " + selector + ": " + node + " }";
    }

}
