/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;

import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;

/**
 * Simple query result implementation.
 * 
 * @deprecated
 */
public class SimpleQueryResult implements QueryResult {

    /**
     * The column names of this query.
     */
    private final String[] columnNames;

    /**
     * The selector names of this query.
     */
    private final String[] selectorNames;

    /**
     * Query result rows. Set to <code>null</code> when the iterator has
     * already been accessed.
     */
    private RowIterator rowIterator;
    
    private long totalNumberOfResults;

    /**
     * Creates a query result with the given column and selector names and
     * row iterator.
     *
     * @param columnNames column names
     * @param selectorNames selector names
     * @param rowIterator iterator over matching rows
     */
    public SimpleQueryResult(
            String[] columnNames, String[] selectorNames,
            RowIterator rowIterator,
            long totalNumberOfResults) {
        assert columnNames != null;
        assert selectorNames != null && selectorNames.length >= 1;
        assert rowIterator != null;
        this.columnNames = columnNames;
        this.selectorNames = selectorNames;
        this.rowIterator = rowIterator;
        this.totalNumberOfResults = totalNumberOfResults;
    }

    public long getTotalNumberOfResults() {
    	return this.totalNumberOfResults;
    }
    
    /**
     * Returns the column names of this query. Note that the returned array
     * is not protected against modification by the client application.
     *
     * @return column names
     */
    public String[] getColumnNames() {
        return columnNames;
    }

    /**
     * Returns the selector names of this query. Note that the returned array
     * is not protected against modification by the client application.
     *
     * @return selector names
     */
    public String[] getSelectorNames() {
        return selectorNames;
    }

    /**
     * Returns the query result rows.
     *
     * @return query result rows
     * @throws RepositoryException if the query results have already
     *                             been iterated through
     */
    public synchronized RowIterator getRows() throws RepositoryException {
        if (rowIterator != null) {
            RowIterator iterator = rowIterator;
            rowIterator = null;
            return iterator;
        } else {
            throw new RepositoryException(
                    "This query result has already been iterated through");
        }
    }

    /**
     * Returns the nodes that match this query.
     *
     * @return matching nodes
     * @throws RepositoryException if this query has more than one selector,
     *                             or if the query results have already been
     *                             iterated through
     */
    public NodeIterator getNodes() throws RepositoryException {
        if (selectorNames.length == 1) {
            return new NodeIteratorAdapter(getRows()) {
                @Override
                public Object next() {
                    Row row = (Row) super.next();
                    try {
                        return row.getNode();
                    } catch (RepositoryException e) {
                        throw new RuntimeException(
                                "Unable to access the node in " + row, e);
                    }
                }
            };
        } else {
            throw new RepositoryException(
                    "This query result contains more than one selector");
        }
    }

}
