/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.searchcollections.qom;

import static javax.jcr.PropertyType.DATE;
import static javax.jcr.PropertyType.DECIMAL;
import static javax.jcr.PropertyType.DOUBLE;
import static javax.jcr.PropertyType.LONG;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_EQUAL_TO;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_GREATER_THAN;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_LESS_THAN;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_LIKE;
import static javax.jcr.query.qom.QueryObjectModelConstants.JCR_OPERATOR_NOT_EQUAL_TO;

import java.util.Comparator;
import java.util.regex.Pattern;

import javax.jcr.RepositoryException;
import javax.jcr.Value;

/**
 * Comparator for {@link Value} instances.
 * 
 * @deprecated
 */
public class ValueComparator implements Comparator<Value> {

    /**
     * Compares two values.
     */
    public int compare(Value a, Value b) {
        try {
            int ta = a.getType();
            int tb = b.getType();

            if ((ta == DECIMAL || ta == DOUBLE || ta == LONG)
                    && (tb == DECIMAL || tb == DOUBLE || tb == LONG)) {
                return a.getDecimal().compareTo(b.getDecimal());
            } else if (ta == DATE && tb == DATE) {
                return a.getDate().compareTo(b.getDate());
            } else {
                return a.getString().compareTo(b.getString());
            }
        } catch (RepositoryException e) {
            throw new RuntimeException(
                    "Unable to compare values " + a + " and " + b, e);
        }
    }

    /**
     * Evaluates the given QOM comparison operation with the given values.
     *
     * @param operator QOM comparison operator
     * @param a left value
     * @param b right value
     * @return result of the comparison
     */
    public boolean evaluate(String operator, Value a, Value b) {
        if (JCR_OPERATOR_EQUAL_TO.equals(operator)) {
            return compare(a, b) == 0;
        } else if (JCR_OPERATOR_GREATER_THAN.equals(operator)) {
            return compare(a, b) > 0;
        } else if (JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO.equals(operator)) {
            return compare(a, b) >= 0;
        } else if (JCR_OPERATOR_LESS_THAN.equals(operator)) {
            return compare(a, b) < 0;
        } else if (JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO.equals(operator)) {
            return compare(a, b) <= 0;
        } else if (JCR_OPERATOR_NOT_EQUAL_TO.equals(operator)) {
            return compare(a, b) != 0;
        } else if (JCR_OPERATOR_LIKE.equals(operator)) {
            try {
                Pattern pattern = createRegexp(b.getString());
                return pattern.matcher(a.getString()).matches();
            } catch (RepositoryException e) {
                throw new RuntimeException(
                        "Unable to compare values " + a + " and " + b, e);
            }
        } else {
            throw new IllegalArgumentException(
                    "Unknown comparison operator: " + operator);
        }
    }

    /**
     * Evaluates the given QOM comparison operation with the given value arrays.
     *
     * @param operator QOM comparison operator
     * @param a left values
     * @param b right values
     * @return result of the comparison
     */
    public boolean evaluate(String operator, Value[] a, Value[] b) {
        if (JCR_OPERATOR_EQUAL_TO.equals(operator)) {
            for (int i = 0; i < a.length; i++) {
                for (int j = 0; j < b.length; j++) {
                    if (compare(a[i], b[j]) == 0) {
                        return true;
                    }
                }
            }
        }
        return false; // FIXME
    }

    /**
     * Creates a regexp from <code>likePattern</code>.
     *
     * @param likePattern the pattern.
     * @return the regular expression <code>Pattern</code>.
     */
    private Pattern createRegexp(String likePattern) {
        // - escape all non alphabetic characters
        // - escape constructs like \<alphabetic char> into \\<alphabetic char>
        // - replace non escaped _ % into . and .*
        StringBuffer regexp = new StringBuffer();
        boolean escaped = false;
        for (int i = 0; i < likePattern.length(); i++) {
            if (likePattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                } else {
                    escaped = true;
                }
            } else {
                if (Character.isLetterOrDigit(likePattern.charAt(i))) {
                    if (escaped) {
                        regexp.append("\\\\").append(likePattern.charAt(i));
                        escaped = false;
                    } else {
                        regexp.append(likePattern.charAt(i));
                    }
                } else {
                    if (escaped) {
                        regexp.append('\\').append(likePattern.charAt(i));
                        escaped = false;
                    } else {
                        switch (likePattern.charAt(i)) {
                            case '_':
                                regexp.append('.');
                                break;
                            case '%':
                                regexp.append(".*");
                                break;
                            default:
                                regexp.append('\\').append(likePattern.charAt(i));
                        }
                    }
                }
            }
        }
        return Pattern.compile(regexp.toString(), Pattern.DOTALL);
    }

}