/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.sightly;

import org.apache.sling.api.SlingHttpServletRequest;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.wcm.api.WCMMode;

/**
 * The {@code SightlyWCMMode} is a helper class around {@link WCMMode}, allowing for easier testing of the WCM mode in Sightly scripts.
 *
 * This class is not meant to be extended.
 **/
@ProviderType
public class SightlyWCMMode {
    private final boolean isDisabled;
    private final boolean isPreview;
    private final boolean isAnalytics;
    private final boolean isReadOnly;
    private final boolean isEdit;
    private final boolean isDesign;

    private final SlingHttpServletRequest request;

    public SightlyWCMMode(SlingHttpServletRequest request) {
        this.request = request;

        this.isEdit = (WCMMode.fromRequest(request) == WCMMode.EDIT);
        this.isDesign = (WCMMode.fromRequest(request) == WCMMode.DESIGN);
        this.isDisabled = (WCMMode.fromRequest(request) == WCMMode.DISABLED);
        this.isPreview = (WCMMode.fromRequest(request) == WCMMode.PREVIEW);
        this.isAnalytics = (WCMMode.fromRequest(request) == WCMMode.ANALYTICS);
        this.isReadOnly = (WCMMode.fromRequest(request) == WCMMode.READ_ONLY);
    }

    public boolean isDisabled () {
        return this.isDisabled;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public boolean isAnalytics() {
        return this.isAnalytics;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public boolean isDesign() {
        return this.isDesign;
    }

    @Override
    public String toString() {
        return WCMMode.fromRequest(request).name();
    }
}
