/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.sightly;

import java.util.HashMap;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.wcm.api.WCMMode;
import org.apache.commons.lang3.StringUtils;

/**
 * The {@code WCMResourceOptions} class is designed as a helper class for storing options used for including resources into Sightly
 * scripts through {@code data-sly-resource}.
 *
 * This class is not meant to be extended.
 */
@ProviderType
public class WCMResourceOptions extends HashMap<String, String> {

    public static final String OPTION_WCMMODE = "wcmmode";
    public static final String OPTION_DECORATION_TAG_NAME = "decorationTagName";
    public static final String OPTION_CSS_CLASS = "cssClassName";

    public WCMMode getWCMMode() {
        String mode = get(OPTION_WCMMODE);
        if (StringUtils.isNotEmpty(mode)) {
            return WCMMode.valueOf(mode.toUpperCase());
        }
        return null;
    }

    public String getDecorationTagName() {
        return get(OPTION_DECORATION_TAG_NAME);
    }

    public String getCssClassName() {
        return get(OPTION_CSS_CLASS);
    }

    public void setOptionDecorationTagName(String decorationTagName) {
        put(OPTION_DECORATION_TAG_NAME, getInternalValue(decorationTagName));
    }

    public void setCssClassName(String cssClassName) {
        put(OPTION_CSS_CLASS, getInternalValue(cssClassName));
    }

    public void setWcmMode(String wcmMode) {
        put(OPTION_WCMMODE, getInternalValue(wcmMode));
    }

    private String getInternalValue(String value) {
        if (StringUtils.isEmpty(value)) {
            return StringUtils.EMPTY;
        }
        return value;
    }
}
