/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.sightly;

import javax.script.Bindings;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import aQute.bnd.annotation.ConsumerType;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import io.sightly.java.api.Use;

/**
 * Abstract implementation of {@link Use} interface. This could be extended to provide custom Use models.
 *
 * @deprecated For future implementations use the {@link WCMUsePojo} class.
 **/
@Deprecated
@ConsumerType
public abstract class WCMUse implements Use {

    private static final Logger LOG = LoggerFactory.getLogger(WCMUse.class);

    private Bindings bindings;

    /**
     * Initialize bindings and calls #activate()
     *
     * @param scriptBindings Bindings to be used, there is no guarantee of having any particular bindings available.
     *
     * */
    public void init(Bindings scriptBindings) {
        bindings = scriptBindings;
        try {
            activate();
        } catch (Exception e) {
            LOG.error("Failed to activate Use class", e);
        }
    }

    /**
     * Implement this method to perform post initialization tasks.
     * This is called from the WCMUse#init
     *
     * @throws Exception in case of any error during activation
     *
     * */
    public abstract void activate() throws Exception;

    /**
     * Get an object associated with the given name
     *
     * @param name  Object property name
     * @param type  Expected object type
     *
     * @return Object or null if Object cannot be found or typed.
     *
     * */
    public <T> T get(String name, Class<T> type) {
        Object obj = bindings.get(name);
        try {
            return type.cast(obj);
        } catch (ClassCastException e) {
            LOG.error("Failed to cast value", e);
        }
        return null;
    }

    /**
     * @return {@link WCMBindings#WCM_MODE} binding if available, otherwise null is returned
     * */
    public SightlyWCMMode getWcmMode() {
        return get(WCMBindings.WCM_MODE, SightlyWCMMode.class);
    }

    /**
     * @return {@link WCMBindings#PAGE_MANAGER} binding if available, otherwise null is returned
     * */
    public PageManager getPageManager() {
        return get(WCMBindings.PAGE_MANAGER, PageManager.class);
    }

    /**
     * @return {@link WCMBindings#CURRENT_PAGE} binding if available, otherwise null is returned
     * */
    public Page getCurrentPage() {
        return get(WCMBindings.CURRENT_PAGE, Page.class);
    }

    /**
     * @return {@link WCMBindings#RESOURCE_PAGE} binding if available, otherwise null is returned
     * */
    public Page getResourcePage() {
        return get(WCMBindings.RESOURCE_PAGE, Page.class);
    }

    /**
     * @return {@link WCMBindings#PAGE_PROPERTIES} binding if available, otherwise null is returned
     * */
    public ValueMap getPageProperties() {
        return get(WCMBindings.PAGE_PROPERTIES, ValueMap.class);
    }

    /**
     * @return {@link WCMBindings#PROPERTIES} binding if available, otherwise null is returned
     * */
    public ValueMap getProperties() {
        return get(WCMBindings.PROPERTIES, ValueMap.class);
    }

    /**
     * @return {@link WCMBindings#DESIGNER} binding if available, otherwise null is returned
     * */
    public Designer getDesigner() {
        return get(WCMBindings.DESIGNER, Designer.class);
    }

    /**
     * @return {@link WCMBindings#CURRENT_DESIGN} binding if available, otherwise null is returned
     * */
    public Design getCurrentDesign() {
        return get(WCMBindings.CURRENT_DESIGN, Design.class);
    }

    /**
     * @return {@link WCMBindings#CURRENT_STYLE} binding if available, otherwise null is returned
     * */
    public Style getCurrentStyle() {
        return get(WCMBindings.CURRENT_STYLE, Style.class);
    }

    /**
     * @return {@link WCMBindings#COMPONENT} binding if available, otherwise null is returned
     * */
    public Component getComponent() {
        return get(WCMBindings.COMPONENT, Component.class);
    }

    /**
     * @return {@link WCMBindings#INHERITED_PAGE_PROPERTIES} binding if available, otherwise null is returned
     * */
    public ValueMap getInheritedProperties() {
        return get(WCMBindings.INHERITED_PAGE_PROPERTIES, ValueMap.class);
    }

    /**
     * @return Sling {@link org.apache.sling.api.scripting.SlingBindings#RESOURCE} binding if available, otherwise null is returned
     * */
    public Resource getResource() {
        return get(SlingBindings.RESOURCE, Resource.class);
    }

    /**
     * @return ResourceResolver associated with the current request
     * */
    public ResourceResolver getResourceResolver() {
        return getRequest().getResourceResolver();
    }

    /**
     * @return Sling {@link org.apache.sling.api.scripting.SlingBindings#REQUEST} binding if available, otherwise null is returned
     * */
    public SlingHttpServletRequest getRequest() {
        return get(SlingBindings.REQUEST, SlingHttpServletRequest.class);
    }

    /**
     * @return Sling {@link org.apache.sling.api.scripting.SlingBindings#RESPONSE} binding if available, otherwise null is returned
     * */
    public SlingHttpServletResponse getResponse() {
        return get(SlingBindings.RESPONSE, SlingHttpServletResponse.class);
    }

    /**
     * @return sling script helper binding {@link org.apache.sling.api.scripting.SlingBindings#SLING} if available, otherwise null is returned
     * */
    public SlingScriptHelper getSlingScriptHelper() {
        return get(SlingBindings.SLING, SlingScriptHelper.class);
    }
}
