/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.sightly;

import javax.script.Bindings;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;

/**
 * Abstract implementation of {@link Use} interface. This could be extended to provide custom Use models.
 **/
@ConsumerType
@SuppressWarnings("unused")
public abstract class WCMUsePojo implements Use {

    private static final Logger LOG = LoggerFactory.getLogger(WCMUsePojo.class);

    private Bindings bindings;
    private SightlyWCMMode wcmMode;
    private PageManager pageManager;
    private Page currentPage;
    private Page resourcePage;
    private ValueMap pageProperties;
    private ValueMap properties;
    private Designer designer;
    private Design currentDesign;
    private Style currentStyle;
    private Component component;
    private ValueMap inheritedProperties;
    private Resource resource;
    private ResourceResolver resourceResolver;
    private SlingHttpServletRequest slingHttpServletRequest;
    private SlingHttpServletResponse slingHttpServletResponse;
    private SlingScriptHelper slingScriptHelper;
    private ComponentContext componentContext;
    private EditContext editContext;
    private Design resourceDesign;
    private XSSAPI xssapi;

    /**
     * Initialize bindings and calls #activate()
     *
     * @param scriptBindings Bindings to be used, there is no guarantee of having any particular bindings available.
     *
     * */
    public final void init(Bindings scriptBindings) {
        bindings = scriptBindings;
        try {
            activate();
        } catch (Exception e) {
            LOG.error("Failed to activate Use class", e);
        }
    }

    /**
     * Implement this method to perform post initialization tasks.
     * This is called from the WCMUse#init
     *
     * @throws Exception in case of any error during activation
     *
     * */
    public abstract void activate() throws Exception;

    /**
     * Get an object associated with the given name
     *
     * @param name  Object property name
     * @param type  Expected object type
     *
     * @return Object or null if Object cannot be found or typed.
     *
     * */
    public final <T> T get(String name, Class<T> type) {
        Object obj = bindings.get(name);
        try {
            return type.cast(obj);
        } catch (ClassCastException e) {
            LOG.error("Failed to cast value", e);
        }
        return null;
    }

    /**
     * @return {@link WCMBindings#WCM_MODE} binding if available, otherwise null is returned
     * */
    public final SightlyWCMMode getWcmMode() {
        if (wcmMode == null) {
            wcmMode = get(WCMBindings.WCM_MODE, SightlyWCMMode.class);
        }
        return wcmMode;
    }

    /**
     * @return {@link WCMBindings#PAGE_MANAGER} binding if available, otherwise null is returned
     * */
    public final PageManager getPageManager() {
        if (pageManager == null) {
            pageManager = get(WCMBindings.PAGE_MANAGER, PageManager.class);
        }
        return pageManager;
    }

    /**
     * @return {@link WCMBindings#CURRENT_PAGE} binding if available, otherwise null is returned
     * */
    public final Page getCurrentPage() {
        if (currentPage == null) {
            currentPage = get(WCMBindings.CURRENT_PAGE, Page.class);
        }
        return currentPage;
    }

    /**
     * @return {@link WCMBindings#RESOURCE_PAGE} binding if available, otherwise null is returned
     * */
    public final Page getResourcePage() {
        if (resourcePage == null) {
            resourcePage = get(WCMBindings.RESOURCE_PAGE, Page.class);
        }
        return resourcePage;
    }

    /**
     * @return {@link WCMBindings#PAGE_PROPERTIES} binding if available, otherwise null is returned
     * */
    public final ValueMap getPageProperties() {
        if (pageProperties == null) {
            pageProperties = get(WCMBindings.PAGE_PROPERTIES, ValueMap.class);
        }
        return pageProperties;
    }

    /**
     * @return {@link WCMBindings#PROPERTIES} binding if available, otherwise null is returned
     * */
    public final ValueMap getProperties() {
        if (properties == null) {
            properties = get(WCMBindings.PROPERTIES, ValueMap.class);
        }
        return properties;
    }

    /**
     * @return {@link WCMBindings#DESIGNER} binding if available, otherwise null is returned
     * */
    public final Designer getDesigner() {
        if (designer == null) {
            designer = get(WCMBindings.DESIGNER, Designer.class);
        }
        return designer;
    }

    /**
     * @return {@link WCMBindings#CURRENT_DESIGN} binding if available, otherwise null is returned
     * */
    public final Design getCurrentDesign() {
        if (currentDesign == null) {
            currentDesign = get(WCMBindings.CURRENT_DESIGN, Design.class);
        }
        return currentDesign;
    }

    /**
     * @return {@link WCMBindings#CURRENT_STYLE} binding if available, otherwise null is returned
     * */
    public final Style getCurrentStyle() {
        if (currentStyle == null) {
            currentStyle = get(WCMBindings.CURRENT_STYLE, Style.class);
        }
        return currentStyle;
    }

    /**
     * @return {@link WCMBindings#COMPONENT} binding if available, otherwise null is returned
     * */
    public final Component getComponent() {
        if (component == null) {
            component = get(WCMBindings.COMPONENT, Component.class);
        }
        return component;
    }

    /**
     * @return {@link WCMBindings#INHERITED_PAGE_PROPERTIES} binding if available, otherwise null is returned
     * */
    public final ValueMap getInheritedProperties() {
        if (inheritedProperties == null) {
            inheritedProperties = get(WCMBindings.INHERITED_PAGE_PROPERTIES, ValueMap.class);
        }
        return inheritedProperties;
    }

    /**
     * @return Sling {@link SlingBindings#RESOURCE} binding if available, otherwise null is returned
     * */
    public final Resource getResource() {
        if (resource == null) {
            resource = get(SlingBindings.RESOURCE, Resource.class);
        }
        return resource;
    }

    /**
     * @return ResourceResolver associated with the current request
     * */
    public final ResourceResolver getResourceResolver() {
        if (resourceResolver == null) {
            resourceResolver = getRequest().getResourceResolver();
        }
        return resourceResolver;
    }

    /**
     * @return Sling {@link SlingBindings#REQUEST} binding if available, otherwise null is returned
     * */
    public final SlingHttpServletRequest getRequest() {
        if (slingHttpServletRequest == null) {
            slingHttpServletRequest = get(SlingBindings.REQUEST, SlingHttpServletRequest.class);
        }
        return slingHttpServletRequest;
    }

    /**
     * @return Sling {@link SlingBindings#RESPONSE} binding if available, otherwise null is returned
     * */
    public final SlingHttpServletResponse getResponse() {
        if (slingHttpServletResponse == null) {
            slingHttpServletResponse = get(SlingBindings.RESPONSE, SlingHttpServletResponse.class);
        }
        return slingHttpServletResponse;
    }

    /**
     * @return sling script helper binding {@link SlingBindings#SLING} if available, otherwise null is returned
     * */
    public final SlingScriptHelper getSlingScriptHelper() {
        if (slingScriptHelper == null) {
            slingScriptHelper = get(SlingBindings.SLING, SlingScriptHelper.class);
        }
        return slingScriptHelper;
    }

    /**
     * @return {@link WCMBindings#COMPONENT_CONTEXT} binding if available, otherwise null is returned
     */
    public final ComponentContext getComponentContext() {
        if (componentContext == null) {
            componentContext = get(WCMBindings.COMPONENT_CONTEXT, ComponentContext.class);
        }
        return componentContext;
    }

    /**
     * @return {@link WCMBindings#EDIT_CONTEXT} binding if available, otherwise null is returned
     */
    public final EditContext getEditContext() {
        if (editContext == null) {
            editContext = get(WCMBindings.EDIT_CONTEXT, EditContext.class);
        }
        return editContext;
    }

    /**
     * @return {@link WCMBindings#RESOURCE_DESIGN} binding if available, otherwise null is returned
     */
    public final Design getResourceDesign() {
        if (resourceDesign == null) {
            resourceDesign = get(WCMBindings.RESOURCE_DESIGN, Design.class);
        }
        return resourceDesign;
    }

    /**
     * @return {@link WCMBindings#XSSAPI} binding if available, otherwise null is returned
     */
    public final XSSAPI getXSSAPI() {
        if (xssapi == null) {
            xssapi = get(WCMBindings.XSSAPI, XSSAPI.class);
        }
        return xssapi;
    }
}
