/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.api;

import com.adobe.granite.activitystreams.Activity;

/**
 * <code>Activity</code> Note that property names and descriptions were reused from
 * http://activitystrea.ms/specs/json/1.0/. Although that document specifies how activities are serialized in JSON the
 * names and concepts can be reused. Additional properties and behaviors are added where the JSON abstraction is not
 * suitable. All properties referring to IDs or URLs may return a path instead of an absolute IRI if the activity is
 * still present in the repository. It is the tasks of the exporting servlet to make them absolute.
 */
public interface SocialActivity extends Activity {
    /**
     * Describes the target of the activity. The precise meaning of the activity's target is dependent on the
     * activities verb, but will often be the object the English preposition "to". For instance, in the activity,
     * "John saved a movie to his wishlist", the target of the activity is "wishlist". The activity target MUST NOT be
     * used to identity an indirect object that is not a target of the activity. An activity MAY contain a target
     * property whose value is a single Object.
     */
    @Override
    SocialActivityObject getTarget();

    /**
     * Describes the primary object of the activity. For instance, in the activity,
     * "John saved a movie to his wishlist", the object of the activity is "movie". An activity SHOULD contain an
     * object property whose value is a single Object. If the object property is not contained, the primary object of
     * the activity MAY be implied by context.
     */
    @Override
    SocialActivityObject getObject();
}
