/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.api;

import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityCollection;
import com.adobe.granite.activitystreams.ActivityException;

/**
 * A simple collection of activities usually aggregated from several activity streams.
 */
public interface SocialActivityCollection extends ActivityCollection {

    /**
     * Returns <code>length</code> activities of this stream, starting at <code>offset</code>.
     * @param offset number of activities to skip
     * @param length number of activities to return. specifying a value &lt;= 0 returns all activities.
     * @param filter search filter
     * @return a collection of activities
     * @throws ActivityException if an error occurs.
     */
    Iterable<Activity> getActivities(int offset, int length, UgcFilter filter) throws ActivityException;

}
