/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.api;

import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityManager;

/**
 * The activity manager is used as entry point to read, create and write activities and activity streams.
 */
public interface SocialActivityManager extends ActivityManager {

    /**
     * Returns the activity stream for the given resource.
     * @param streamResource the stream resource
     * @return the stream
     * @throws ActivityException if an error occurs
     */
    SocialActivityStream getSocialStream(Resource streamResource) throws ActivityException;

    /**
     * Gets the distinct activity stream for the given authorizable.
     * @param resolver resource resolver to resolve the path
     * @param auth the jackrabbit authorizable
     * @param streamName the name of the stream or <code>null</code> to use the default stream
     * @param create create stream if it doesn't exist
     * @return the activity stream or <code>null</code> if the user or his stream does not exist.
     * @throws ActivityException if an error occurs
     */
    SocialActivityStream getSocialStream(ResourceResolver resolver, Authorizable auth, String streamName,
        boolean create) throws ActivityException;

    /**
     * Returns the activity stream for the given container resource, e.g. user, group, document. If the stream does
     * not exist and <code>create</code> is <code>true</code> a new stream is created.
     * @param containerResource the container resource
     * @param name the stream name
     * @param create create stream if it doesn't exist
     * @return the stream or <code>null</code> if no such stream exists
     * @throws ActivityException if an error occurs
     */
    SocialActivityStream getSocialStream(Resource containerResource, String name, boolean create)
        throws ActivityException;

    /**
     * Delete an activity from a activity stream.
     * @param activity The activity to delete from the stream
     * @throws ActivityException When error occurs
     */
    void deleteActivity(final Activity activity) throws ActivityException;

}
