/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.api;

import org.apache.sling.api.resource.Resource;

import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityObject;

/**
 * Provides an abstraction of an activity stream. The stream is a collection of activities that usually belong to the
 * same underlying stream. The stream is bound to the jcr session requesting the stream and therefor subject to access
 * control.
 */
public interface SocialActivityObject extends ActivityObject {

    /**
     * @return the resource that this object is bound to using the object's getId() value. Returns null if the getId()
     *         value can't be resolved to a resource or if the property {@link SocialJsonConstants#IS_VIRTUAL} is not
     *         set to true or the property does not exist.
     * @throws com.adobe.granite.activitystreams.ActivityException if an error occurs.
     */
    Resource getResource() throws ActivityException;

    /**
     * @return true if {@link SocialJsonConstants#IS_VIRTUAL} property exists and is set to false, otherwise returns
     *         false.
     */
    boolean isNotVirtual();

}
