/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.api;

import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityStream;

/**
 * Provides an abstraction of an activity stream. The stream is a collection of activities that usually belong to the
 * same underlying stream. The stream is bound to the jcr session requesting the stream and therefor subject to access
 * control.
 */
public interface SocialActivityStream extends ActivityStream {

    /**
     * Returns <code>length</code> activities of this stream, starting at <code>offset</code>.
     * @param offset number of activities to skip
     * @param length number of activities to return.
     * @param filter search filter
     * @return a collection of activities
     * @throws com.adobe.granite.activitystreams.ActivityException if an error occurs.
     */
    Iterable<Activity> getActivities(int offset, int length, UgcFilter filter) throws ActivityException;

}
