/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.api;

import com.adobe.granite.activitystreams.JsonConstants;

/**
 * Adding social specific constants here.
 */
public interface SocialJsonConstants extends JsonConstants {

    /**
     * Property name for the activity target id. The _s suffix indicates that the property is searchable.
     */
    String PROPERTY_TARGET_ID = "targetid_s";

    /**
     * Set this property to false if the activity object doesn't have an associated resource. This property is
     * optional but if property is present and is set to false, then the object's resource can be retrieved via the
     * {@link com.adobe.cq.social.activitystreams.api.SocialActivityObject#getResource()}.
     */
    String IS_VIRTUAL = "isVirtual";

}
