/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.activitystreams.listener.api;

import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityException;

/**
 * Activity stream storage provider.
 */
public interface ActivityStreamProvider {
    String DEFAULT_STREAM_NAME = "community";
    /**
     * OSGi configuration for activity stream path name
     */
    String PROP_BASE_PATH_NAME = "streamPath";
    /**
     * OSGi configuration for stream name
     */
    String PROP_STREAM_NAME = "streamName";

    /**
     * Check if the target activity stream provider accepts the new event and correspondent activity
     * @param activity
     * @return true if the stream provider needs to append the new activity into its stream.
     */
    boolean accept(final Activity activity);

    /**
     * Appends a new activity to this stream.
     * @param activity the activity to write.
     * @throws ActivityException if an error occurs.
     */
    <T> void append(final Activity activity) throws ActivityException;

}
