/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.activitystreams.listener.api;

import java.util.Map;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.core.SocialEvent;

/**
 * Event listener extension. An event listener extension can add custom properties to an activity, or veto an event so
 * that no activity is generated for that event.
 */
public interface EventListenerExtension {
    /**
     * Get the name of this extension
     */
    String getName();

    /**
     * Determine if the specified {@link SocialEvent} would generating a {@link UserActivities}
     * com.adobe.granite.activitystreams.Activity stream
     * @param event the Social event
     * @param resource the resource, the activity object. This value can be null.
     * @return <code>true</code> if the system should generate an activity stream for the specified event.
     */
    boolean evaluate(final SocialEvent<?> event, final Resource resource);

    /**
     * Get the ranking index for this extension.
     * @return
     */
    int getRanking();

    /**
     * Get additional properties for the specified {@link SocialEvent}. The keys of the returned map could be one of
     * the properties declared in {@link #com.adobe.granite.activitystreams.JsonConstants}
     */
    Map<String, ? extends Object> getActivityProperties(final SocialEvent<?> event, final Resource resource);

    /**
     * Get additional object properties for the specified {@link SocialEvent}. The keys of the returned map could be
     * one of the properties declared in {@link #com.adobe.granite.activitystreams.JsonConstants}
     */
    Map<String, ? extends Object> getObjectProperties(final SocialEvent<?> event, final Resource resource);

    /**
     * Get additional actor properties for the specified {@link SocialEvent}. The keys of the returned map could be
     * one of the properties declared in {@link #com.adobe.granite.activitystreams.JsonConstants}
     */
    Map<String, ? extends Object> getActorProperties(final SocialEvent<?> event, final Resource resource);

    /**
     * Get the target properties for the specified {@link SocialEvent}. The keys of the returned map could be one of
     * the properties declared in {@link #com.adobe.granite.activitystreams.JsonConstants}
     */
    Map<String, ? extends Object> getTargetProperties(final SocialEvent<?> event, final Resource resource);

}
