/**************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.badging.api;

import javax.annotation.Nonnull;

import org.apache.sling.api.resource.Resource;

/**
 * A user's badge info containing the image path and whether it's an assigned badge.
 */
public interface UserBadge {
    /**
     * @return absolute path to the badge image resource.
     */
    @Nonnull
    String getImagePath();

    /**
     * @return true if badge is an assigned badge.
     */
    boolean isAssigned();

    /**
     * @return the resource of the badge.
     */
    @Nonnull
    Resource getResource();
}
