/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.calendar.client.api;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.forum.client.api.Forum;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Simply Social Calendar, a collection of CalendarEvent.
 */
public interface Calendar extends Forum<CalendarEvent, CalendarConfiguration> {
    /**
     * Calendar component resource type.
     */
    String RESOURCE_TYPE = "social/calendar/components/hbs/calendar";

    /**
     * Calendar event resource type.
     */
    String RESOURCE_TYPE_EVENT = "social/calendar/components/hbs/event";

    /**
     * Calendar event reply resource type.
     */
    String RESOURCE_TYPE_EVENT_REPLY = "social/calendar/components/hbs/event_comment";

    /**
     * Pagination and date filter selector's separator.
     */
    String SELECTOR_SEPARATOR = "_";

    /**
     * Returns the resource path of this calendar.
     * @return - resource path of this calendar.
     */
    String getPath();

    /**
     * Returns the title of this calendar.
     * @return - title of this calendar.
     */
    String getName();

    /**
     * Get the range of date applies to this calendar instance.
     * @return - date range filter.
     */
    @JsonIgnore
    DateRangeFilter getDateRangeFilter();

    /**
     * Set the date range filter.
     * @param dateFilter - Date Filter to set.
     */
    void setDateRangeFilter(final DateRangeFilter dateFilter);

    /**
     * Get the default date range filter start date.
     * @return - date range filter start
     */
    String getDefaultDateRangeFilterStart();

    /**
     * Get the default date range filter end date.
     * @return - date range filter end
     */
    String getDefaultDateRangeFilterEnd();

    /**
     * Creates the configuration.
     * @param eventResource the event resource
     * @param calendarResouce the calendar resouce
     * @return the calendar configuration
     */
    CalendarConfiguration createConfiguration(final Resource eventResource, final Resource calendarResouce);
}
