/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.calendar.client.api;

import java.util.Calendar;

import com.adobe.cq.social.forum.client.api.Post;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Interface CalendarEvent.
 */
public interface CalendarEvent extends Post<CalendarConfiguration> {

    /**
     * Returns the icalendar UID, which is a globally unique identifier for events.
     * @return the uid
     */
    String getUid();

    /**
     * Returns the start date of the event. If it is an all-day event, {@link #isDate()} will return true and the time
     * part can be ignored.
     * @return the start
     */
    Calendar getStart();

    /**
     * Returns the end date of the event. If it is an all-day event, {@link #isDate()} will return true and the time
     * part can be ignored.
     * @return the end
     */
    Calendar getEnd();

    /**
     * Returns if this event is an all-day event.
     * @return true, if is date
     */
    @JsonProperty("isDate")
    boolean isDate();

    /**
     * Returns if this event is part of a recurring series. This will return <code>true</code> if this is the original
     * event that defines a recurrence or if it is {@link #CalendarRecurrenceEvent.isRecurrence() a recurring event
     * instance}.
     * @return <code>true</code> if this event is part of a recurring series
     * @see #CalendarRecurrenceEvent.isRecurrence()
     * @see #CalendarRecurrenceEvent.getOriginal()
     */
    boolean isRecurringSeries();

    /**
     * Returns whether this event is the recurring instance of an event with recurring rule(s). To get the original
     * event, use {@link #getOriginal()}. Note that for the original event, which is also part of the recurring event
     * series, this will return <code>false</code>. To find out if an event is part of a recurring series, use
     * @return <code>true</code> if this is a recurrence, <code>false</code> if this is the original event
     *         {@link #isRecurringSeries()}.
     *         <p>
     *         Recurring events are copied into the JCR for each instance to allow for simpler display and search,
     *         without the need to dynamically re-calculate the recurrence on each read access.
     * @see #isRecurringSeries()
     * @see #getOriginal()
     */
    boolean isRecurrence();

    /**
     * Checks if the event is multiday event.
     * @return true, if is multiday
     */
    boolean getIsMultiday();

    /**
     * Get this Event parent id.
     * @return this Event parent id.
     */
    String getCalendarId();
}
