/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.calendar.client.api;

import java.util.List;

import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationExtension;

/**
 * Declaration of the Calendar Operations.
 */
public interface CalendarOperationsExtension extends OperationExtension<CalendarEvent> {
    /**
     * Operation types.
     */
    public enum CalendarOperation implements Operation {
        /** Create Operation. */
        CREATE,
        /** Update operation. */
        UPDATE,
        /** Delete operation. */
        DELETE,
        /** Image upload operation. */
        UPLOADIMAGE;
    };

    /**
     * Get the list of operations that this operation extension is interested in.
     * @return a list of {@link CalendarOperation}
     */
    @Override
    List<CalendarOperation> getOperationsToHookInto();
}
