/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.api;

import java.util.Calendar;

import com.adobe.cq.social.scf.SocialCollectionComponent;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * A <code>CommentCollection</code> represents a collection of {@link Comment}s. Comments can be added to and removed
 * from the collection. A collection is tied to a specific target (e.g. the page, asset or node that was commented on)
 * - see {@link #getTarget()}.
 * @param <C>
 */
public interface CommentCollection<C extends Comment, T extends CommentCollectionConfiguration> extends
    SocialCollectionComponent {

    /**
     * Returns the moment in time this collection was created.
     * @return The calendar representing the creation date/time.
     */
    Calendar getCreated();

    /**
     * Returns the moment in time this collection was last modified.
     * @return The calendar representing the last modification.
     */
    Calendar getLastModified();

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();

    /**
     * Checks if is tagging allowed.
     * @return true, if is tagging allowed
     */
    @JsonIgnoreProperties
    boolean isTaggingAllowed();

    /**
     * Get the configuration for this collection
     */
    T getConfiguration();

    /**
     * @return <code>true</code> if the Post action button should be displayed
     */
    boolean getMayPost();

}
