/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.fasterxml.jackson.annotation.JsonProperty;

public interface CommentCollectionConfiguration {
    /**
     * The property name for allowing users to vote.
     */
    String PN_ALLOW_VOTING = "allowVoting";

    /**
     * The default value of Allow Voting property
     */
    boolean PV_DEFAULT_ALLOW_VOTING = false;

    /**
     * The property name of the allowing users voting root.
     */
    String PN_VOTING_ROOT = "votingRoot";

    String PN_ALLOW_TAGGING = "allowTagging";

    /**
     * The default value of allow users voting root.
     */
    String PV_DEFAULT_VOTING_ROOT = "voting";

    /**
     * The property name of the voting type.
     */
    String PN_VOTING_TYPE = "votingType";

    /**
     * The default value of allow users voting type.
     */
    String PV_DEFAULT_VOTING_TYPE = "social/tally/components/hbs/voting";

    /**
     * The property name for allowing users or moderators to delete comments.
     */
    String PN_ALLOW_DELETE_COMMENTS = "allowDeleteComments";

    /**
     * The default property value for allowing users or moderators to delete comments.
     */
    boolean PV_DEFAULT_ALLOW_DELETE_COMMENTS = false;

    /**
     * The property name for allowing users to flag comments.
     */
    String PN_ALLOW_FLAGGING = "allowFlagComments";

    /**
     * The default property value for allowing users to flag comments.
     */
    boolean PV_DEFAULT_ALLOW_FLAGGING = false;

    /**
     * The property name for allowing users to close comments.
     */
    String PN_ALLOW_CLOSE = "allowCloseComments";

    /**
     * The default property value for allowing users to close comments.
     */
    boolean PV_DEFAULT_ALLOW_CLOSE = false;

    /**
     * The property name for allowing users to deny comments.
     */
    String PN_ALLOW_DENY = "allowDenyComments";

    /**
     * The property name for allowing users to move threads.
     */
    String PN_ALLOW_MOVE = "allowMoves";

    /**
     * The default property value for allowing users to deny comments.
     */
    boolean PV_DEFAULT_ALLOW_DENY = false;

    /**
     * The property name for enabling the rich text editor.
     */
    String PN_RTE_ENABLED = "rteEnabled";

    /**
     * The default state of the rich text editor.
     */
    boolean PV_DEFAULT_RTE_ENABLED = false;

    /**
     * The property name for allowing users to attach files.
     */
    String PN_ALLOW_ATTACHMENT = "allowFileUploads";

    /**
     * The default property value for allowing users to attach files.
     */
    boolean PV_DEFAULT_ALLOW_ATTACHMENT = false;

    /**
     * The property name for allowing users to use a typed in flag reason.
     */
    String PN_ALLOW_CUSTOM_FLAGREASON = "allowCustomFlagReason";

    /**
     * The default property value for allowing a custom flag reason.
     */
    boolean PV_DEFAULT_ALLOW_CUSTOM_FLAGREASON = false;

    /**
     * The property name for allowing users to translate a whole thread.
     */
    String PN_ALLOW_TRANSLATE_ALL = "allowTranslateAllButton";

    /**
     * The default property value for allowing user to translate a whole thread.
     */
    boolean PV_DEFAULT_ALLOW_TRANSLATE_ALL = false;

    /**
     * The property name for the maximum number of comments on a page.
     */
    String PN_MAX_ITEMS_PER_PAGE = "maxPerPage";

    /**
     * The property name for the allow Following.
     */
    String PN_ALLOW_FOLLOWING = "allowFollowing";

    /**
     * The default property value for allowing following.
     */
    boolean PV_DEFAULT_ALLOW_FOLLOWING = false;

    /**
     * The property name for showing badges.
     */
    String PN_SHOW_BADGES = BadgingService.ALLOW_BADGES_PROP;

    /**
     * The default property value for showing badges.
     */
    boolean PV_DEFAULT_SHOW_BADGES = false;

    /**
     * The property name for the allowing replies to comments.
     */
    public final static String PN_ALLOW_REPLIES = "allowRepliesToComments";

    /**
     * The default property value for allowing replies.
     */
    boolean PV_DEFAULT_ALLOW_REPLIES = false;

    /**
     * The default property value for allowing moves.
     */
    boolean PV_DEFAULT_ALLOW_MOVE = true;

    /** The restricted users group. */
    static String ALLOW_PRIVILEGED_MEMBERS = "allowPrivilegedMembers";
    static String PRIVILEGED_USERS_GROUP = "cq:privilegedMembers";

    /** The default sort order */
    static String PN_SORT_ORDER = "sortOrder";

    /**
     * @return true if the comment can be voted
     */
    @JsonProperty("isVotingAllowed")
    boolean isVotingAllowed();

    /**
     * Allows attachment.
     * @return true, if successful
     */
    @JsonProperty("isAttachmentAllowed")
    boolean isAttachmentAllowed();

    /**
     * Checks if is RTE enabled.
     * @return true, if is RTE enabled
     */
    @JsonProperty("isRTEEnabled")
    boolean isRTEEnabled();

    /**
     * @return boolean indicating if custom flag reasons are allowed. The JCR of this attribute is called
     *         "seFlagReasonFreeformText"
     */
    @JsonProperty("isCustomFlagReasonAllowed")
    boolean isCustomFlagReasonAllowed();

    /**
     * @return boolean indicating if translate all button are allowed. The JCR of this attribute is called
     *         "allowTranslateAllButton"
     */
    @JsonProperty("isTranslateAllButtonAllowed")
    boolean isTranslateAllButtonAllowed();

    /**
     * @return boolean indicating if closing a tree of replies is allowed.The JCR of this attribute is called
     *         "allowCloseComments"
     */
    boolean isCloseAllowed();

    /**
     * @return boolean indicating if flagging content is allowed.The JCR of this attribute is called
     *         "allowFlagComments"
     */
    boolean isFlaggingAllowed();

    /**
     * @return boolean indicating if denying a tree of replies is allowed.The JCR of this attribute is called
     *         "allowDenyComments"
     */
    boolean isDenyAllowed();

    /**
     * @return boolean indicating if moving a thread is allowed.The JCR of this attribute is called "allowMove"
     */
    boolean isMoveAllowed();

    /**
     * @return boolean indicating if denying a tree of replies is allowed. The JCR of this attribute is called
     *         "allowDenyComments"
     */
    boolean isEditAllowed();

    /**
     * @return boolean indicating if replying to comments is allowed. The JCR of this attribute is called
     *         "allowRepliesToComments"
     */
    boolean isReplyAllowed();

    /**
     * @return boolean indicating if deleting comments is allow for a user. The JCR of this attribute is called
     *         "allowDeleteComments"
     */
    boolean isDeleteAllowed();

    /**
     * @return the default number of comments on a page as configured on the component. If there is no configuration,
     *         this defaults to 10.
     */
    int getPageSize();

    /**
     * @return setting value of the following allowed configuration.
     */
    boolean isFollowingAllowed();

    /**
     * @return the default sort order of comments on a page as configured on the component. If there is no
     *         configuration, this defaults to {@link CollectionSortedOrder}.REVERSED_ORDER.
     */
    CollectionSortedOrder getSortOrder();
}
