/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.api;

import javax.jcr.RepositoryException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.comments.impl.CommentImpl;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialCollectionComponentFactory;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

/**
 * Social Comment Component Factory which allows the framework to create an {@link SocialComponent} for a
 * {@link Resource} with a {@link Comment.RESOURCETYPE}.
 */
@Component
@Service
public class CommentSocialComponentFactory extends AbstractSocialComponentFactory implements
    SocialCollectionComponentFactory {
    /**
     * Get the component for the specified resource.
     * @param resource the comment resource
     * @return the component
     */

    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        try {
            return new CommentImpl(resource, getClientUtilities(resource.getResourceResolver()), listProviderManager);
        } catch (final RepositoryException e) {
            return null;
        }
    }

    /**
     * Get the component for the specified resource.
     * @param resource the comment resource.
     * @param request the client request.
     * @return the component
     */
    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        try {
            return new CommentImpl(resource, getClientUtilities(request), getQueryRequestInfo(request),
                listProviderManager);
        } catch (final RepositoryException e) {
            return null;
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryInfo) {
        try {
            return new CommentImpl(resource, clientUtils, queryInfo, listProviderManager);
        } catch (final RepositoryException e) {
            return null;
        }
    }

    /**
     * Get the resource type that this factory supports.
     * @return the resource type.
     */
    @Override
    public String getSupportedResourceType() {
        return Comment.COMMENT_RESOURCETYPE;
    }
}
