/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.comments.impl.CommentCollectionImpl;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialCollectionComponentFactory;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

/**
 * <code>SocialComponent</code> factory class.
 */
@Component
@Service
public class CommentSystemSocialComponentFactory extends AbstractSocialComponentFactory implements
    SocialCollectionComponentFactory {

    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    /**
     * Get the <code>SocialComponent</code> for the specified resource.
     * @param resource the <code>CommentSystem</code> resource.
     * @return the target <code>SocialComponent</code>
     */
    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return new CommentCollectionImpl(resource, getClientUtilities(resource.getResourceResolver()),
            listProviderManager);
    }

    /**
     * Get the <code>SocialComponent</code> for the specified resource and request.
     * @param resource the <code>CommentSystem</code> resource
     * @param request the client request
     * @return the target <code>SocialComponent</code>
     */
    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new CommentCollectionImpl(resource, getClientUtilities(request), getQueryRequestInfo(request),
            listProviderManager);
    }

    /**
     * @inheritDoc
     */
    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo requestInfo) {
        return new CommentCollectionImpl(resource, clientUtils, requestInfo, listProviderManager);
    }

    /**
     * Get the supported resource type.
     * @return <code>CommentSystem.RESOURCE_TYPE</code>
     */
    @Override
    public String getSupportedResourceType() {
        return Comment.COMMENTCOLLECTION_RESOURCETYPE;
    }
}
