/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.endpoints;

import java.util.List;
import java.util.Map;

import javax.activation.DataSource;
import javax.jcr.Session;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.OperationException;

/**
 * CRUD Operation of a {@link com.adobe.cq.social.commons.comments.api.Comment}.
 */
public interface CommentOperations {
    /**
     * Create a new comment base on the specified {@link SlingHttpServletRequest} using the specified {@link Session}.
     * @param request the client request
     * @param session the user session to be used to create the new comment
     * @return the new {@link com.adobe.cq.social.commons.comments.api.Comment}
     * @throws OperationException if there is an error occurs
     */
    Resource create(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Create a comment with the specified {@link Map} of properties and {@link List} of attachments.
     * @param root the root resource of the comment to be created
     * @param author the user name
     * @param props a list of properties for the new comment
     * @param attachments a list of comment attachments
     * @param session the user session to be used to create the new comment
     * @return the new {@link com.adobe.cq.social.commons.comments.api.Comment}
     * @throws OperationException if there is an error occurs
     */
    Resource create(final Resource root, final String author, final Map<String, Object> props,
        final List<DataSource> attachments, final Session session) throws OperationException;

    /**
     * Update a {@link com.adobe.cq.social.commons.comments.api.Comment} base on the specified
     * {@link SlingHttpServletRequest} using the specified. {@link Session}.
     * @param request
     * @param session
     * @return the update comment
     * @throws OperationException if there is an error occurs
     */
    Resource update(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Update the specified comment with the specified {@link Map} of properties and {@link List} of attachments.
     * @param commentResource the target comment
     * @param props a map of the properties to be updated
     * @param attachments a list of attachment to be added to the specified comment
     * @param session the user session to be used to perform the operation
     * @return the new updated comment
     * @throws OperationException if there is an error occurs
     */
    Resource update(final Resource commentResource, final Map<String, Object> props,
        final List<DataSource> attachments, final Session session) throws OperationException;

    /**
     * Upload image.
     * @param request the request
     * @param session the session
     * @return the resource of the image
     * @throws OperationException if an error occurs
     */
    Resource uploadImage(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Delete a {@link com.adobe.cq.social.commons.comments.api.Comment} specified by the
     * {@link SlingHttpServletRequest} using the specified {@link Session}.
     * @param request the http request which specifies the target comment
     * @param session the user session to be used to perform the operation
     * @throws OperationException if there is an error occurs
     */
    void delete(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Delete a {@link com.adobe.cq.social.commons.comments.api.Comment} using the specified {@link Session}.
     * @param commentResource the target comment
     * @param session the user session to be used to delete the specified comment.
     * @throws OperationException if there is an error occurs
     */
    void delete(final Resource commentResource, final Session session) throws OperationException;

    /**
     * Perform a move operation. Required parameters from the request are: 1. "resourcePath" - the path pointing to
     * the resource being moved 2. "parentPath" - the path pointing to the new target parent resource
     * @param request the request
     * @param session the session
     * @return the resource after the move
     * @throws OperationException
     */
    Resource move(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Move the provided resource onto the provided parent resource
     * @param commentResource the resource being moved
     * @param parentResource the target parent resource
     * @param session the session
     * @return the resource after the move
     * @throws OperationException
     */
    Resource move(final Resource commentResource, final Resource parentResource, final Session session)
        throws OperationException;
}
