/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.comments.endpoints;

import java.util.Map;

import javax.jcr.Session;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.OperationException;

public interface TranslationOperations extends CommentOperations {

    /**
     * Edit the translation of {@link Comment} based on the specified {@link SlingHttpServletRequest} using the
     * specified {@link Session}.
     * @param request
     * @param session
     * @return the updated comment with modified translation
     * @throws OperationException if there is an error occurs
     */
    Resource editTranslation(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Edit the translation of {@link Comment} for a {@link Resource} based on the specified userID, requestURI,
     * referer using the specified {@link Session} and {@link Map} of properties.
     * @param resource the comment resource whose translation is being edited
     * @param session the user session to be used to perform the operation
     * @param userID to get user language
     * @param requestURI to get page language
     * @param referer to get page language
     * @param browserLanguage to get browser language if user language is missing
     * @param editedTranslation the modified translation that needs to be updated and stored
     * @param props a list of properties for the comment
     * @return the updated comment with modified translation
     * @throws OperationException if there is an error occurs
     */
    Resource editTranslation(final Resource resource, final Session session, final String userID,
        final String requestURI, final String referer, final String browserLanguage, final String editedTranslation,
        final Map<String, Object> props) throws OperationException;

}
