/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.listing;

import java.util.List;

import javax.jcr.RepositoryException;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollection;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.ugc.api.PathConstraintType;

/**
 * A collection of a comments. This interface is used by a {@link CommentCollection}, or a {@link Comment} to store
 * its children.
 */
public interface CommentSocialComponentList extends List<Object> {
    /** Default embedded depth. */
    int DEFAULT_DEPTH = 1;

    /**
     * Get total size of the collection.
     * @return total comments in the list
     */
    int getTotalSize();

    /**
     * Set the collection pagination.
     * @param pagination the pagination settings for the output
     */
    void setPagination(final CollectionPagination pagination);

    /**
     * Set the sorted order of the list
     */
    void setSortedOrder(CollectionSortedOrder sortedOrder);

    /**
     * Get the pagination setting.
     * @return the pagination setting.
     */
    CollectionPagination getPagination();

    /**
     * Gets a strongly typed list of comments.
     * @return the list of comments managed by this list
     */
    List<Comment> getComments() throws RepositoryException;

    /**
     * Set the path constraint to use in the search
     * @param pathConstraint the path constraint to be used
     */
    void setPathConstraint(PathConstraintType pathConstraint);
}
