/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.listing;

import java.util.List;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollection;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.ugcbase.SocialUtils;

/**
 * An interface that defines comment list providers that can retrieve a list of comments based on a specific set of
 * constraints like query/sort/resource type, etc.
 * @param <C>
 */
public interface CommentSocialComponentListProvider {
    /**
     * @param commentCollection - the comment collection instance for which the list of comments is to be retrieved.
     * @param listInfo - parameters that define the list
     * @param clientUtils - an instance of {@link ClientUtilities}
     * @return a {@link CommentSocialComponentList} that contains the list of comments retrieved
     */
    <C extends Comment, T extends CommentCollectionConfiguration> CommentSocialComponentList getCommentSocialComponentList(
        CommentCollection<C, T> commentCollection, QueryRequestInfo listInfo, ClientUtilities clientUtils);

    /**
     * @param comment - the comment instance for which the list of comments is to be retrieved.
     * @param listInfo - parameters that define the list
     * @param clientUtils - an instance of {@link ClientUtilities}
     * @return a {@link CommentSocialComponentList} that contains the list of comments retrieved
     */
    <C extends Comment> CommentSocialComponentList getCommentSocialComponentList(C comment,
        QueryRequestInfo listInfo, ClientUtilities clientUtils);

    /**
     * Allows a caller to determine whether this provider can retrieve the list of comments for the given resource.
     * @param commentCollectionResource - the resource for which a list of comments is to be retrieved.
     * @param socialUtils - an instance of {@link SocialUtils}
     * @return true if this provider can retrieve a list for the resource, false otherwise.
     */
    boolean checkResource(Resource commentCollectionResource, SocialUtils socialUtils);

    /**
     * @return a list of resource types for which this provider can retrieve a list of comments for.
     */
    List<String> getSupportedResourceType();

    /**
     * @param listInfo - the list parameters for which provider might have to retireve a list for
     * @return true, if the provider can handle the constrains (like sort criteria, filter parameters) specified in
     *         the listInfo, false otherwise.
     */
    boolean acceptQuery(QueryRequestInfo listInfo);
}
