/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.comments.listing;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.scf.QueryRequestInfo;

/**
 * A class that helps determine which {@link CommentSocialComponentListProvider} to use, given a resource and a
 * {@link QueryRequestInfo} list parameters.
 */
public interface CommentSocialComponentListProviderManager {
    /**
     * @param resource - the resource for which a {@link CommentSocialComponentListProvider} is to be found.
     * @param listInfo - the list parameters for which {@link CommentSocialComponentListProvider} is to be a found.
     * @return {@link CommentSocialComponentListProvider} if one is found.
     */
    <C extends Comment, T extends CommentCollectionConfiguration> CommentSocialComponentListProvider getCommentSocialComponentListProvider(
        final Resource resource, final QueryRequestInfo listInfo);
}
