/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.comments.search;

import java.util.Properties;
import com.adobe.cq.social.scf.SocialComponent;

public interface SearchComponent extends SocialComponent {
    String RESOURCE_TYPE = "social/commons/components/hbs/search";

    /**
     * Property for search paths.
     */
    String PN_SEARCHPATHS = "searchPaths";

    /**
     * Property for search result page.
     */
    String PN_RESULT_PAGE = "resultPage";

    /**
     * Get the search paths
     * @return
     */
    String[] getPaths();

    /**
     * Get the available languages
     * @return
     */
    Properties[] getAvailableLanguages();

    /**
     * Get search resource page
     */
    String getResultPage();

}
