/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.emailreply;

import org.apache.commons.mail.Email;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.activitystreams.api.SocialActivity;

/**
 * The {@code CommentEmailBuilder} builds {@link Email}s based on the given {@link ResourceResolver}s,
 * {@link SocialActivity} and recipient user id. As well builder uses {@link EmailContent} of the unsuccessful reply
 * emails to build failure notification email. The builder is OSGi service that is looked up as service references
 * while sending an email for an occurring notification.
 */
public interface CommentEmailBuilder {

    /**
     * Property unique tracker id of comment resource to which comment parsed from email is to be added.
     */
    String TRACKER_ID_PROPERTY = "trackerId";

    /**
     * Builds an email message from the given resource resolvers, social activity, recipient user id and reply-to
     * email address.
     * @param ugcWriterResourceResolver the resource resolver used to obtain the resource in the JCR
     * @param userReaderResourceResolver the resource resolver used to obtain access to the users directory
     * @param utilityReaderResourceResolver the resource resolver used to obtain access to the email templates
     *            directory
     * @param socialActivity social activity based on any subscribable comment event
     * @param recipientUserId recipient user id
     * @return built email
     */
    Email build(final ResourceResolver ugcWriterResourceResolver, final ResourceResolver userReaderResourceResolver,
        final ResourceResolver utilityReaderResourceResolver, final SocialActivity socialActivity,
        final String recipientUserId);

    /**
     * Builds an email failure message from the given resource resolvers and reply email content.
     * @param userReaderResourceResolver the resource resolver used to obtain access to the users directory
     * @param utilityReaderResourceResolver the resource resolver used to obtain access to the email templates
     *            directory
     * @param replyEmailContent the content of the unsuccessful reply email
     * @return built failure notification email
     */
    Email buildFailure(final ResourceResolver userReaderResourceResolver,
        final ResourceResolver utilityReaderResourceResolver, final EmailContent replyEmailContent);
}
