/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.emailreply;

import java.util.List;
import java.util.Properties;

import com.adobe.cq.social.commons.FileDataSource;

/**
 * Provides ability to wrap email properties and attachments in a single unit and get them separately when needed.
 */
public interface EmailContent {

    /**
     * Returns the properties of a parsed e-mail.
     * @return properties of mail containing information about email content, comment unique id, author id, email
     *         subject and parsing client used
     */
    Properties getProperties();

    /**
     * Returns the list of attachments from a parsed e-mail.
     * @return list of Data Sources, which is the list of attachments retrieved from the parsed mail
     */
    List<FileDataSource> getAttachments();
}
