/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.emailreply;

import com.adobe.cq.social.commons.CollabException;

/**
 * <code>EmailReplyException</code> is a generic exception for all failures in the email reply feature.
 */
public class EmailReplyException extends CollabException {

    /** A serialVersionUID for this class. */
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new CollabException with the specified message and cause.
     * @param message The detailed message
     */
    public EmailReplyException(final String message) {
        super(message);
    }

    /**
     * Constructs a new CollabException with the specified message and cause.
     * @param message The detailed message
     * @param cause The cause
     */
    public EmailReplyException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new CollabException with the specified message and cause.
     * @param cause The cause
     */
    public EmailReplyException(final Throwable cause) {
        super(cause);
    }

}
