/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.emailreply;

import java.io.IOException;

import javax.mail.BodyPart;
import javax.mail.MessagingException;

import com.adobe.cq.social.commons.FileDataSource;

/**
 * {@link FileDataSource} factory.
 */
public interface FileDataSourceFactory {

    /**
     * Get the instance of {@link FileDataSource} class implementation.
     * @param bodypart {@link BodyPart}
     * @throws IOException thrown by stream handler
     * @throws MessagingException thrown by stream handler
     * @return {@link FileDataSource} instance
     */
    FileDataSource getFileDataSource(final BodyPart bodypart) throws IOException, MessagingException;
}
