/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.events.PublishEvent.PublishActions;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.granite.activitystreams.Verbs;
import com.day.text.Text;

/**
 * Defines events that are triggered in a comment system.
 */
public class PublishEvent extends SocialEvent<PublishActions> {

    private static final long serialVersionUID = 1L;

    /**
     * List of available publish actions that can trigger a publish event.
     */
    public static enum PublishActions implements SocialEvent.SocialActions {
        PUBLISHED;

        @Override
        public String getVerb() {
            switch (this) {
                case PUBLISHED:
                    return Verbs.POST;
                default:
                    throw new IllegalArgumentException();
            }
        }

    }

    public PublishEvent(final String topic, final Resource resource, final String parentPath, final String userId,
        final PublishActions action, final EventObject source, final EventObject destination) {
        super(topic, resource.getPath(), userId, action, source, destination, new HashMap<String, Object>(1) {
            private static final long serialVersionUID = 1L;
            {
                this.put(PATH, parentPath);
            }
        });
    }

    protected static String getObjectName(final Resource resource) {
        return "a " + Text.getName(resource.getResourceType());
    }

}
