/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.listing;

import java.util.List;

/**
 * Maintain a collection of data which is used by the CommenListProvider. The collection starts from a specified
 * offset and has a specified size. The collection also maintains the total number of items <E> in the repository.
 */
public interface CommentListCollection<E> extends List<E> {
    /**
     * Get the total comments of the instance
     * @return
     */
    int totalCount();

    /**
     * Get the beginning offset
     */
    int getOffset();
}
