/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.listing;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.QueryRequestInfo;

/**
 * Comments node type are sorted in different ordered for different component. The {@link CommentListProvider} allows
 * a client to obtain the children of a resource sorted in the right order of its usage.
 */
public interface CommentListProvider<E> {
    /**
     * Get a subset of {@link Comment} of the specified root resource as defined by the given offset and size. The
     * comments are returned in chronological order.
     * @param resource the target resource.
     * @param offset the offset starting from 0.
     * @param size the max number of elements to return.
     * @param reversedOrder specifies the list is sorted in chronological order or not. This parameter only supports
     *            if the list provider supports sorting.
     * @param commentIndexElementFactory the {@link CommentIndexElementFactory} used to create {@link Comment} object
     *            from an IndexElement.
     * @return The list of comments with the specified offset and size.
     */
    CommentListCollection<E> getComments(final Resource resource, final QueryRequestInfo listInfo);

    /**
     * Get the resource types this provider supports
     * @return a list resource type this provider supports.
     */
    public String[] getSupportedResourceType();
}
