/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.listing;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.comments.api.Comment;

/**
 * a {@link CommentListProviderManager} service manages registered {@link CommentListProvider}.
 */
public interface CommentListProviderManager {
    /**
     * Get the listing provider for the specified resource.
     * @param resource the resource for which comment list manager is needed.
     * @return the CommentListProvider for the specified resource
     */
    CommentListProvider<? extends Comment> getCommentListProvider(final Resource resource);

    /**
     * Get the {@link CommentListProvider} for the specify resource type.
     * @param resourceType the specified resource type
     * @return a {@link CommentListProvider} that handles the specified resource type, or null if there is no
     *         registered {@link CommentListProvider}
     */
    CommentListProvider<? extends Comment> getCommentListProvider(String resourceType);
}
